-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

THObjectParent = {}
local THObjectParent_mt = THUtils.createClass(THObjectParent, Object)
THUtils.initClass(THObjectParent, "THObjectParent", THClassType.OBJECT)
THObject = {}
local THObject_mt = THUtils.createClass(THObject)
local function getCustomData(target)
    return THUtils.getDataTable(target, THObject)
end
THObject.getCustomData = getCustomData
function THObject.registerXMLPaths(xmlSchema, xmlPath)
    if THUtils.argIsValid(type(xmlSchema) == "table", "xmlSchema", xmlSchema)
        and THUtils.argIsValid(type(xmlPath) == "string", "xmlPath", xmlPath)
    then
        return true
    end
    return false
end
function THObject.new(isServer, isClient, customMt, objectMt, ...)
    customMt = customMt or THObject_mt
    objectMt = objectMt or THObjectParent_mt
    if THUtils.argIsValid(type(isServer) == "boolean", "isServer", isServer)
        and THUtils.argIsValid(type(isClient) == "boolean", "isClient", isClient)
        and THUtils.argIsValid(type(customMt) == "table", "customMt", customMt)
        and THUtils.argIsValid(type(objectMt) == "table", "objectMt", objectMt)
    then
        local parent = Object.new(isServer, isClient, objectMt)
        if parent ~= nil then
            local self = THUtils.createDataTable(parent, THObject, customMt, ...)
            if self ~= nil then
                self.parent = parent
                self.isServer = parent.isServer == true
                self.isClient = parent.isClient == true
                parent:register(true)
                return self
            end
        end
    end
end
function THObject.delete(self)
    return self.parent:delete()
end
function THObject.raiseActive(self)
    return self.parent:raiseActive()
end
function THObject.getNextDirtyFlag(self)
    return self.parent:getNextDirtyFlag()
end
function THObject.raiseDirtyFlags(self, dirtyFlag)
    return self.parent:raiseDirtyFlags(dirtyFlag)
end
function THObject.onDelete(self)
end
function THObject.onUpdate(self, dt)
end
function THObject.onUpdateTick(self, dt)
end
function THObject.onReadStream(self, streamId, connection)
    self:readDataFromStream(streamId, connection)
end
function THObject.onWriteStream(self, streamId, connection)
    self:writeDataToStream(streamId, connection)
end
function THObject.onReadUpdateStream(self, streamId, timestamp, connection)
    self:readDataFromStream(streamId, connection, timestamp)
end
function THObject.onWriteUpdateStream(self, streamId, connection, dirtyMask)
    self:writeDataToStream(streamId, connection, dirtyMask)
end
function THObject.readDataFromStream(self, streamId, connection, timestamp)
end
function THObject.writeDataToStream(self, streamId, connection, dirtyMask)
end
function THObjectParent.delete(self, ...)
    local customData = getCustomData(self)
    local function appendFunc(...)
        if customData ~= nil then
            THUtils.call(function()
                customData:onDelete()
            end)
        end
        return ...
    end
    return appendFunc(THObjectParent:superClass().delete(self, ...))
end
function THObjectParent.update(self, dt, ...)
    local customData = getCustomData(self)
    local function appendFunc(...)
        if customData ~= nil then
            THUtils.call(function()
                customData:onUpdate(dt)
            end)
        end
        return ...
    end
    return appendFunc(THObjectParent:superClass().update(self, dt, ...))
end
function THObjectParent.updateTick(self, dt, ...)
    local customData = getCustomData(self)
    local function appendFunc(...)
        if customData ~= nil then
            THUtils.call(function()
                customData:onUpdateTick(dt)
            end)
        end
        return ...
    end
    return appendFunc(THObjectParent:superClass().updateTick(self, dt, ...))
end
function THObjectParent.readStream(self, streamId, connection, ...)
    local customData = getCustomData(self)
    local function appendFunc(...)
        if customData ~= nil then
            customData:onReadStream(streamId, connection)
        end
        return ...
    end
    return appendFunc(THObjectParent:superClass().readStream(self, streamId, connection, ...))
end
function THObjectParent.writeStream(self, streamId, connection, ...)
    local customData = getCustomData(self)
    local function appendFunc(...)
        if customData ~= nil then
            customData:onWriteStream(streamId, connection)
        end
        return ...
    end
    return appendFunc(THObjectParent:superClass().writeStream(self, streamId, connection, ...))
end
function THObjectParent.readUpdateStream(self, streamId, timestamp, connection, ...)
    local customData = getCustomData(self)
    local function appendFunc(...)
        if customData ~= nil then
            customData:onReadUpdateStream(streamId, timestamp, connection)
        end
        return ...
    end
    return appendFunc(THObjectParent:superClass().readUpdateStream(self, streamId, timestamp, connection, ...))
end
function THObjectParent.writeUpdateStream(self, streamId, connection, dirtyMask, ...)
    local customData = getCustomData(self)
    local function appendFunc(...)
        if customData ~= nil then
            customData:onWriteUpdateStream(streamId, connection, dirtyMask)
        end
        return ...
    end
    return appendFunc(THObjectParent:superClass().writeUpdateStream(self, streamId, connection, dirtyMask, ...))
end