
-- @Author: twproductions
-- @Date: 23.12.2023
-- @Version: 1.0.0.0

RegisterMajorService = {};
local modName = g_currentModName;
local modDir = g_currentModDirectory;
RegisterMajorService.name = g_currentModName;
RegisterMajorService.modDirectory = g_currentModDirectory
local specFile = Utils.getFilename("MajorService.lua", modDir);

function RegisterMajorService.init(typeManager)

	if FS22_RealisticDamageSystem ~= nil and FS22_RealisticDamageSystem.RealisticDamageSystem ~= nil then
        print("MajorService: Realistic Damage Installed Exiting")
		do return end
	end

    g_gui:loadProfiles(RegisterMajorService.modDirectory .. "gui/guiProfiles.xml")

    if g_specializationManager:getSpecializationByName("MajorService") == nil then
        g_specializationManager:addSpecialization("MajorService", "MajorService", specFile, nil);
        print("Mod:  register spec MajorService v"..tostring(version).." by TWProductions");
    end;

    if typeManager.typeName == "vehicle" then
        for vehicleName, vehicleEntry in pairs(g_vehicleTypeManager:getTypes()) do
            if SpecializationUtil.hasSpecialization(Wearable, vehicleEntry.specializations)
                and not SpecializationUtil.hasSpecialization(Locomotive, vehicleEntry.specializations)
            then
                g_vehicleTypeManager:addSpecialization(vehicleName, modName..".MajorService")
                --print("---- MajorService INSTALLED: "..vehicleName)
            end
        end
    end
end

TypeManager.validateTypes = Utils.appendedFunction(TypeManager.validateTypes, RegisterMajorService.init)
