WearableMajorServiceEvent = {}
WearableMajorServiceEvent.debug = false
local WearableMajorServiceEvent_mt = Class(WearableMajorServiceEvent, Event)

InitEventClass(WearableMajorServiceEvent, "WearableMajorServiceEvent")

function WearableMajorServiceEvent.emptyNew()
	return Event.new(WearableMajorServiceEvent_mt)
end

function WearableMajorServiceEvent.new(vehicle)
	local self = WearableMajorServiceEvent.emptyNew()
	self.vehicle = vehicle
	return self
end

function WearableMajorServiceEvent:readStream(streamId, connection)
	self.vehicle = NetworkUtil.readNodeObject(streamId)
	self:run(connection)
end

function WearableMajorServiceEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.vehicle)
end

function WearableMajorServiceEvent:run(connection)
	if not connection:getIsServer() then
		if self.vehicle ~= nil and self.vehicle:getIsSynchronized() and self.vehicle.serviceVehicle ~= nil then
			if WearableMajorServiceEvent.debug then
				print("---- WearableMajorServiceEvent: run Not Server")
			end
		
			g_currentMission:addMoney(-self.vehicle:getServiceCost(), self.vehicle:getOwnerFarmId(), MoneyType.VEHICLE_REPAIR, true, true)
			self.vehicle:serviceVehicle()
			g_server:broadcastEvent(self)
			--g_messageCenter:publish(MessageType.VEHICLE_REPAIRED, self.vehicle)
		end
	else
		if WearableMajorServiceEvent.debug then
			print("---- WearableMajorServiceEvent: run Server")
		end
	self.vehicle:serviceVehicle()
		--g_messageCenter:publish(MessageType.VEHICLE_REPAIRED, self.vehicle)
	end
end
