fcDebug("farmCleanup Class")

FarmCleanup = {}
FarmCleanup.modDirectory = g_currentModDirectory
local FarmCleanup_mt = Class(FarmCleanup, Event)

InitEventClass(FarmCleanup, "FarmCleanup")

function FarmCleanup.new(mission, i18n, modDirectory, modName)
  fcDebug("FCU-New")
  local self = setmetatable({}, FarmCleanup_mt)
  self.mission          = mission
  self.i18n             = i18n
  self.modDirectory     = modDirectory
  self.modName          = modName
  self.runCurrentMinute = 0
  self.isServer         = g_currentMission:getIsServer()
  self.coopCruiseAbuse  = {}

  -- Load mod default settings
  self.settings = FS25PrefSaver:new(
    "FS25_FarmsCleanup",
    "FarmsCleanupSettings.xml",
    false,
    {
      autoCleanPallets      = {false, "bool"},
      autoCleanBales        = {false, "bool"},
      autoCleanLogs         = {false, "bool"},
      autoCleanStumps       = {false, "bool"},
      costPerPallet         = {1, "int"},
      costPerBale           = {1, "int"},
      costPerLog            = {1, "int"},
      costPerStump          = {1, "int"},
      daysAllowedPallets    = {4, "int"},
      daysAllowedBales      = {4, "int"}
    },
		nil,
		nil
  )

  self.costPer = {"0","100","250","500","750","1000","2500","5000","7500","10000"}

  g_messageCenter:subscribe(MessageType.DAY_CHANGED, self.onDayChanged, self)

	return self
end

-- Run on map load
-- FS25 - There is a new way to load menus.  Will have to come back to this.
function FarmCleanup:loadMap(filename)
  fcDebug(" Info: FCS-loadMap")

	self.settings:loadSettings()
	self.settings:saveSettings()

  local InfoFrame = SettingsGuiInfoFrame:new(nil, g_i18n)
  local SettingsFrame = SettingsGuiSettingsFrame:new(nil, g_i18n)

  g_gui:loadProfiles(FarmCleanup.modDirectory .. "gui/guiProfiles.xml")

  FarmCleanup.gui = SettingsGui:new(g_messageCenter, g_i18n, g_inputBinding)

  g_gui:loadGui(FarmCleanup.modDirectory .. "gui/SettingsGuiInfoFrame.xml", "SettingsGuiInfoFrame", InfoFrame, true)
  g_gui:loadGui(FarmCleanup.modDirectory .. "gui/SettingsGuiSettingsFrame.xml", "SettingsGuiSettingsFrame", SettingsFrame, true)
  g_gui:loadGui(FarmCleanup.modDirectory .. "gui/SettingsGui.xml", "SettingsGui", FarmCleanup.gui)

end

-- Register Player Interaction
function FarmCleanup:updateActionEvents()
  -- We have to run this often to work in MP
	local _, actionEventId = g_inputBinding:registerActionEvent('FC_MENU', self, FarmCleanup.actionAdditionalInfo_openGui, false, true, false, true)
	g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_LOW)
  g_inputBinding:setActionEventText(actionEventId, g_i18n:getText("FC_MENU"))
end

-- Load the gui
function FarmCleanup:actionAdditionalInfo_openGui(actionName, keyStatus, arg3, arg4, arg5)
  fcDebug(" Info: FCS-actionAdditionalInfo_openGui")
  if g_gui.currentGui == nil then
    -- Load the gui
    g_gui:showGui("SettingsGui")
  end
end

function FarmCleanup:update(dt)
  -- Register the button input
  FarmCleanup:updateActionEvents()
end

-- Run on savegame
function FarmCleanup:saveToXMLFile()
  fcDebug(" Info: FCS-saveToXMLFile")

  g_farmCleanup.settings:saveSettings()
end

-- Refresh Settings Menus
function FarmCleanup:refresh()
  if g_dedicatedServer == nil then
    SettingsGuiSettingsFrame:updateSettings()
  end
end

-- Event when player joins server
function FarmCleanup:join()
  fcDebug("FCSettings:join")
  -- Send settings to new client
  SettingEvent.sendEvent(2, "autoCleanPallets", g_farmCleanup.settings:getValue("autoCleanPallets"))
  SettingEvent.sendEvent(2, "autoCleanBales", g_farmCleanup.settings:getValue("autoCleanBales"))
  SettingEvent.sendEvent(2, "autoCleanLogs", g_farmCleanup.settings:getValue("autoCleanLogs"))
  SettingEvent.sendEvent(2, "autoCleanStumps", g_farmCleanup.settings:getValue("autoCleanStumps"))
  SettingEvent.sendEvent(3, "costPerPallet", g_farmCleanup.settings:getValue("costPerPallet"))
  SettingEvent.sendEvent(3, "costPerBale", g_farmCleanup.settings:getValue("costPerBale"))
  SettingEvent.sendEvent(3, "costPerLog", g_farmCleanup.settings:getValue("costPerLog"))
  SettingEvent.sendEvent(3, "costPerStump", g_farmCleanup.settings:getValue("costPerStump"))
  SettingEvent.sendEvent(3, "daysAllowedPallets", g_farmCleanup.settings:getValue("daysAllowedPallets"))
  SettingEvent.sendEvent(3, "daysAllowedBales", g_farmCleanup.settings:getValue("daysAllowedBales"))
end

-- Run on day change at midnight in game
function FarmCleanup:onDayChanged()
  fcDebug("FarmCleanup:onDayChanged")
  -- Only run on server side if mp, or on client if sp.
  if (g_currentMission.missionDynamicInfo.isMultiplayer and (g_server ~= nil and self.isServer and g_dedicatedServer ~= nil)) or not g_currentMission.missionDynamicInfo.isMultiplayer then
      -- Run stump clean up
      local autoCleanStumps = g_farmCleanup.settings:getValue("autoCleanStumps")
      if autoCleanStumps ~= nil and autoCleanStumps == true then
          FarmCleanup:cleanStumps()
      end
      -- Run log clean up
      local autoCleanLogs = g_farmCleanup.settings:getValue("autoCleanLogs")
      if autoCleanLogs ~= nil and autoCleanLogs == true then
          FarmCleanup:cleanLogs()
      end
      -- Run pallet cleanup process
      local autoCleanPallets = g_farmCleanup.settings:getValue("autoCleanPallets")
      if autoCleanPallets ~= nil and autoCleanPallets == true then
          FarmCleanup:cleanPallets()
      end
      -- Run bale cleanup process
      local autoCleanBales = g_farmCleanup.settings:getValue("autoCleanBales")
      if autoCleanBales ~= nil and autoCleanBales == true then
          FarmCleanup:cleanBales()
      end
  end

end


-- Loops through all stumps found on map and charges farm owner for the stump removal, then removes the stump.
function FarmCleanup:cleanStumps()
  fcDebug("Scanning for stumps to clean up.")

  local newxmlFile
  local removedStumps = {}
  local numRemoved = 1
  local removeLogs = false
  local removeStumps = true
  local stumpCharge = -self:getChargeAmount(g_farmCleanup.settings:getValue("costPerStump"))

  local _, numSplit = getNumOfSplitShapes()

  if numSplit > 0 then
      local densityManager = g_densityMapHeightManager
      local aiSystem = g_currentMission.aiSystem
      local splitSplitShapes = {}


      self:findAllSplitSplitShapes(getRootNode(), removeLogs, removeStumps, splitSplitShapes)

      for _, splitShape in pairs (splitSplitShapes) do
          local x, _, z = getWorldTranslation(splitShape)

          local farmlandId = g_farmlandManager:getFarmlandIdAtWorldPosition(x,z)
          local farmId = g_farmlandManager:getFarmlandOwner(farmlandId)

          -- save the stump to table
          table.insert(removedStumps, {
            id = numRemoved,
            farmId = farmId,
            farmlandId = farmlandId,
            x = x,
            z = z
          })

          -- Charge the farm for the removal if set
          if stumpCharge ~= nil and stumpCharge ~= 0 then
              local farm = g_farmManager:getFarmById(farmId)
              if farm ~= nil then
                  -- Charge farm for stump removal
                  local moneyType = MoneyType.SOLD_WOOD
                  g_currentMission:addMoneyChange(stumpCharge, farmId, moneyType, true)
                  if farm ~= nil then
                      fcDebug("Stump Removal Charge for farm: " .. farmId)
                      farm:changeBalance(stumpCharge, moneyType)
                  end
              end
          end

          delete(splitShape)

          densityManager:setCollisionMapAreaDirty(x - 10, z - 10, x + 10, z + 10, true)
          aiSystem:setAreaDirty(x - 10, x + 10, z - 10, z + 10)

          numRemoved = numRemoved + 1
      end

      if numRemoved > 0 then
          g_treePlantManager:cleanupDeletedTrees()

          print(string.format(" Info: Farm Cleanup removed %d logs from the map.",numRemoved))

          fcDebug("Saving Deleted Stumps to Logs")

          --Save path and filename
          local timestamp = getDate("%Y-%m-%d-%H-%M")
          local commandOutboxDir = getUserProfileAppPath()  .. "modSettings/FS25_FarmsCleanup/Logs"
          local savedFile = commandOutboxDir .. "/removedStumps" .. timestamp .. ".xml"
          --File Key for xml output
          local key ="removedStumps"

          --save data to xml file
          newxmlFile = XMLFile.create(key, savedFile, key)

          local index = 0

          for _, p in pairs(removedStumps) do

            local subKey = string.format(".stump(%d)", index)

            newxmlFile:setString(key .. subKey .. "#id", tostring(p.id))
            newxmlFile:setString(key .. subKey .. "#farmId", tostring(p.farmId))
            newxmlFile:setString(key .. subKey .. "#farmlandId", tostring(p.farmlandId))
            newxmlFile:setString(key .. subKey .. "#x", tostring(p.x))
            newxmlFile:setString(key .. subKey .. "#z", tostring(p.z))

            index = index + 1
            p = {}
          end

          newxmlFile:save()
          newxmlFile:delete()

      end
  end

  return numRemoved - 1
end

-- Loops through all stumps found on map and charges farm owner for the stump removal, then removes the stump.
function FarmCleanup:cleanLogs()
  fcDebug("Scanning for logs to clean up.")

  local newxmlFile
  local removedLogs = {}
  local farmTreeCount = {}
  local numRemoved = 1
  local removeLogs = true
  local removeStumps = false
  local logCharge = -self:getChargeAmount(g_farmCleanup.settings:getValue("costPerLog"))

  local _, numSplit = getNumOfSplitShapes()

  if numSplit > 0 then
      local densityManager = g_densityMapHeightManager
      local aiSystem = g_currentMission.aiSystem
      local splitSplitShapes = {}


      self:findAllSplitSplitShapes(getRootNode(), removeLogs, removeStumps, splitSplitShapes)

      for _, splitShape in pairs (splitSplitShapes) do

          local x, _, z = getWorldTranslation(splitShape)

          local farmlandId = g_farmlandManager:getFarmlandIdAtWorldPosition(x,z)
          local farmId = g_farmlandManager:getFarmlandOwner(farmlandId)

          -- save the stump to table
          table.insert(removedLogs, {
            id = numRemoved,
            farmId = farmId,
            farmlandId = farmlandId,
            x = x,
            z = z
          })

          -- Charge the farm for the removal if set
          if logCharge ~= nil and logCharge ~= 0 then
              local farm = g_farmManager:getFarmById(farmId)
              if farm ~= nil then
                  -- Charge farm for Log removal
                  local moneyType = MoneyType.SOLD_WOOD
                  g_currentMission:addMoneyChange(logCharge, farmId, moneyType, true)
                  if farm ~= nil then
                      fcDebug("Log Removal Charge for farm: " .. farmId)
                      farm:changeBalance(logCharge, moneyType)
                  end
              end
          end

          delete(splitShape)

          numRemoved = numRemoved + 1

      end

      if numRemoved > 0 then
          g_treePlantManager:cleanupDeletedTrees()

          print(string.format(" Info: Farm Cleanup removed %d stumps from the map.",numRemoved))

          fcDebug("Saving Deleted Stumps to Logs")

          --Save path and filename
          local timestamp = getDate("%Y-%m-%d-%H-%M")
          local commandOutboxDir = getUserProfileAppPath()  .. "modSettings/FS25_FarmsCleanup/Logs"
          local savedFile = commandOutboxDir .. "/removedLogs-" .. timestamp .. ".xml"

          --File Key for xml output
          local key ="removedLogs"

          --save data to xml file
          newxmlFile = XMLFile.create(key, savedFile, key)

          local index = 0

          for _, p in pairs(removedLogs) do

            local subKey = string.format(".log(%d)", index)

            newxmlFile:setString(key .. subKey .. "#id", tostring(p.id))
            newxmlFile:setString(key .. subKey .. "#farmId", tostring(p.farmId))
            newxmlFile:setString(key .. subKey .. "#farmlandId", tostring(p.farmlandId))
            newxmlFile:setString(key .. subKey .. "#x", tostring(p.x))
            newxmlFile:setString(key .. subKey .. "#z", tostring(p.z))

            index = index + 1
            p = {}
          end

          newxmlFile:save()
          newxmlFile:delete()

      end
  end

  return numRemoved - 1

end

function FarmCleanup:findAllSplitSplitShapes(node, findLogs, findStumps, splitSplitShapes)
    for i = 0, getNumOfChildren(node) - 1 do
        local node = getChildAt(node, i)

        if (getName(node) == "splitGeom" and getHasClassId(node, ClassIds.MESH_SPLIT_SHAPE)) and (getSplitType(node) ~= 0 and getIsSplitShapeSplit(node)) then
            local rigidBodyType = getRigidBodyType(node)

            if (findLogs and rigidBodyType == RigidBodyType.DYNAMIC) or (findStumps and rigidBodyType == RigidBodyType.STATIC) then
                splitSplitShapes[node] = node
            end
        else
            self:findAllSplitSplitShapes(node, findLogs, findStumps, splitSplitShapes)
        end
    end
end

function FarmCleanup:cleanPallets()
    fcDebug("FarmCleanup - cleanPallets")

    local numRemoved = 0

    local palletCharge = -self:getChargeAmount(g_farmCleanup.settings:getValue("costPerPallet"))
    local daysAllowedPallets = g_farmCleanup.settings:getValue("daysAllowedPallets")

    local function getVehicleIsPallet(vehicle)

        if vehicle.isPallet or vehicle.typeName == "pallet" or vehicle.typeName == "treeSaplingPallet" or vehicle.typeName == "bigBag" then
            return true
        end

        if vehicle.spec_wheels == nil and vehicle.spec_enterable == nil then
            -- Allow custom pallets with different type names. Must include a valid spec of either Pallet, BigBag or TreeSaplingPallet
            -- Specializations 'Wheels' and 'Enterable' are not invalid and ignored as these should not be part of a pallet
            for _, spec in pairs(vehicle.specializations) do
                if spec == Pallet or spec == BigBag or spec == TreeSaplingPallet then
                    return true
                end
            end
        end

        return false
    end

    local palletSpawnPlaces = {}

    -- Loop through all placeables
    for v = 1, #g_currentMission.placeableSystem.placeables do
      local thisPlaceable = g_currentMission.placeableSystem.placeables[v]
      local typeName = tostring(thisPlaceable.typeName)
      local palletSpawner = nil

      -- Check if pallet spawner data is in placeable by type
      if string.find(typeName, "Husbandry") then
        local specHusbandryPallets = thisPlaceable.spec_husbandryPallets
        if specHusbandryPallets ~= nil then
          palletSpawner = specHusbandryPallets.palletSpawner
        end
      elseif typeName == "productionPoint" or typeName == "productionPointWardrobe" or typeName == "greenhouse" then
        local specProductionPoint = thisPlaceable.spec_productionPoint.productionPoint
        if specProductionPoint ~= nil then
          palletSpawner = specProductionPoint.palletSpawner
        end
      elseif typeName == "beehivePalletSpawner" then
        local specBeehiveSpawner = thisPlaceable.spec_beehivePalletSpawner
        if specBeehiveSpawner ~= nil then
          palletSpawner = specBeehiveSpawner.palletSpawner
        end
      end

      -- Add the pallet spawner locations to table if found
      if palletSpawner ~= nil and palletSpawner.spawnPlaces ~= nil and #palletSpawner.spawnPlaces > 0 then
        for v = 1, #palletSpawner.spawnPlaces do
          local spawnPlace = palletSpawner.spawnPlaces[v]
          table.insert(palletSpawnPlaces, spawnPlace)
        end
      end
    end

    local removedPallets = {}

    for i = #g_currentMission.vehicleSystem.vehicles, 1, -1 do
        local vehicle = g_currentMission.vehicleSystem.vehicles[i]

        if vehicle.isa ~= nil and vehicle:isa(Vehicle) and vehicle.trainSystem == nil then
            if getVehicleIsPallet(vehicle) then
                local x, _, z = getWorldTranslation(vehicle.rootNode)
                -- Check if pallet is in a spawn area, if so then ignore it.
                local withinRadius = false
                if #palletSpawnPlaces ~= nil then
                    for _, s in pairs(palletSpawnPlaces) do
                        local radius = s.width
                        if s.length > s.width then
                          radius = s.length
                        end
                        withinRadius = FarmCleanup:isPointWithinRadius(s.startX, s.startZ, x, z, radius)
                    end
                end
                if withinRadius == false then
                    local farmlandId = g_farmlandManager:getFarmlandIdAtWorldPosition(x,z)
                    local baleData = {
                      id = numRemoved,
                      type = "pallet",
                      farmId = vehicle.ownerFarmId,
                      farmlandId = farmlandId,
                      x = x,
                      z = z,
                      xmlFilename = vehicle.configFileName,
                      isMissionBale = false
                    }
                    local checkItem = FarmCleanup:checkItem(baleData, daysAllowedPallets)
                    if checkItem then
                        fcDebug("Removing Pallet: " .. vehicle.configFileName)
                        -- save the pallet to table
                        table.insert(removedPallets, {
                          id = baleData.id,
                          farmId = baleData.farmId,
                          farmlandId = baleData.farmlandId,
                          x = baleData.x,
                          z = baleData.z
                        })

                        -- Charge the farm for the removal if set
                        if palletCharge ~= nil and palletCharge ~= 0 then
                            local farm = g_farmManager:getFarmById(baleData.farmId)
                            if farm ~= nil then
                                -- Charge farm for pallet removal
                                local moneyType = MoneyType.PURCHASE_PALLETS
                                g_currentMission:addMoneyChange(palletCharge, baleData.farmId, moneyType, true)
                                if farm ~= nil then
                                    fcDebug("Pallet Removal Charge for farm: " .. baleData.farmId)
                                    farm:changeBalance(palletCharge, moneyType)
                                end
                            end
                        end

                        -- g_currentMission.vehicleSystem:removeVehicle(vehicle)
                        vehicle:delete()
                        numRemoved = numRemoved + 1
                    end
                end
            end
        end
    end

    -- Check if pallets removed and send them to website
    if removedPallets ~= nil and #removedPallets > 0 then

      print(string.format(" Info: Farm Cleanup removed %d pallets from the map.",numRemoved))

      --Save path and filename
      local timestamp = getDate("%Y-%m-%d-%H-%M")
      local commandOutboxDir = getUserProfileAppPath()  .. "modSettings/FS25_FarmsCleanup/Logs"
      local savedFile = commandOutboxDir .. "/removedPallets-" .. timestamp .. ".xml"

      --File Key for xml output
      local key ="removedPallets"

      --save data to xml file
      newxmlFile = XMLFile.create(key, savedFile, key)

      local index = 0

      for _, p in pairs(removedPallets) do

        local subKey = string.format(".pallet(%d)", index)

        newxmlFile:setString(key .. subKey .. "#id", tostring(p.id))
        newxmlFile:setString(key .. subKey .. "#farmId", tostring(p.farmId))
        newxmlFile:setString(key .. subKey .. "#farmlandId", tostring(p.farmlandId))
        newxmlFile:setString(key .. subKey .. "#x", tostring(p.x))
        newxmlFile:setString(key .. subKey .. "#z", tostring(p.z))

        index = index + 1
        p = {}
      end

      newxmlFile:save()
      newxmlFile:delete()
    end

    fcDebug("Pallets Removed: " .. numRemoved)

end

function FarmCleanup:cleanPalletsManual()
    fcDebug("FarmCleanup - cleanPalletsManual")

    local numRemoved = 0

    local palletCharge = -self:getChargeAmount(g_farmCleanup.settings:getValue("costPerPallet"))

    local function getVehicleIsPallet(vehicle)

        if vehicle.isPallet or vehicle.typeName == "pallet" or vehicle.typeName == "treeSaplingPallet" or vehicle.typeName == "bigBag" then
            return true
        end

        if vehicle.spec_wheels == nil and vehicle.spec_enterable == nil then
            -- Allow custom pallets with different type names. Must include a valid spec of either Pallet, BigBag or TreeSaplingPallet
            -- Specializations 'Wheels' and 'Enterable' are not invalid and ignored as these should not be part of a pallet
            for _, spec in pairs(vehicle.specializations) do
                if spec == Pallet or spec == BigBag or spec == TreeSaplingPallet then
                    return true
                end
            end
        end
        return false
    end

    local removedPallets = {}

    for i = #g_currentMission.vehicleSystem.vehicles, 1, -1 do
        local vehicle = g_currentMission.vehicleSystem.vehicles[i]

        if vehicle.isa ~= nil and vehicle:isa(Vehicle) and vehicle.trainSystem == nil then
            if getVehicleIsPallet(vehicle) then
                local x, _, z = getWorldTranslation(vehicle.rootNode)
                -- Check if pallet is in a spawn area, if so then ignore it.
                local farmlandId = g_farmlandManager:getFarmlandIdAtWorldPosition(x,z)
                local baleData = {
                  id = numRemoved,
                  type = "pallet",
                  farmId = vehicle.ownerFarmId,
                  farmlandId = farmlandId,
                  x = x,
                  z = z,
                  xmlFilename = vehicle.configFileName,
                  isMissionBale = false
                }
                fcDebug("Removing Pallet: " .. vehicle.configFileName)
                -- save the pallet to table
                table.insert(removedPallets, {
                  id = baleData.id,
                  farmId = baleData.farmId,
                  farmlandId = baleData.farmlandId,
                  x = baleData.x,
                  z = baleData.z
                })

                -- Charge the farm for the removal if set
                if palletCharge ~= nil and palletCharge ~= 0 then
                    local farm = g_farmManager:getFarmById(baleData.farmId)
                    if farm ~= nil then
                        -- Charge farm for pallet removal
                        local moneyType = MoneyType.PURCHASE_PALLETS
                        g_currentMission:addMoneyChange(palletCharge, baleData.farmId, moneyType, true)
                        if farm ~= nil then
                            fcDebug("Pallet Removal Charge for farm: " .. baleData.farmId)
                            farm:changeBalance(palletCharge, moneyType)
                        end
                    end
                end

                -- g_currentMission.vehicleSystem:removeVehicle(vehicle)
                vehicle:delete()
                numRemoved = numRemoved + 1
            end
        end
    end

    -- Check if pallets removed and send them to website
    if removedPallets ~= nil and #removedPallets > 0 then

      print(string.format(" Info: Farm Cleanup removed %d pallets from the map.",numRemoved))

      --Save path and filename
      local timestamp = getDate("%Y-%m-%d-%H-%M")
      local commandOutboxDir = getUserProfileAppPath()  .. "modSettings/FS25_FarmsCleanup/Logs"
      local savedFile = commandOutboxDir .. "/removedPallets-" .. timestamp .. ".xml"

      --File Key for xml output
      local key ="removedPallets"

      --save data to xml file
      newxmlFile = XMLFile.create(key, savedFile, key)

      local index = 0

      for _, p in pairs(removedPallets) do

        local subKey = string.format(".pallet(%d)", index)

        newxmlFile:setString(key .. subKey .. "#id", tostring(p.id))
        newxmlFile:setString(key .. subKey .. "#farmId", tostring(p.farmId))
        newxmlFile:setString(key .. subKey .. "#farmlandId", tostring(p.farmlandId))
        newxmlFile:setString(key .. subKey .. "#x", tostring(p.x))
        newxmlFile:setString(key .. subKey .. "#z", tostring(p.z))

        index = index + 1
        p = {}
      end

      newxmlFile:save()
      newxmlFile:delete()
    end

    fcDebug("Pallets Removed: " .. numRemoved)
    return numRemoved

end

function FarmCleanup:cleanBales()
    fcDebug("FarmCleanup - cleanBales")

    local numRemoved = 0
    local removedBales = {}
    local baleCharge = -self:getChargeAmount(g_farmCleanup.settings:getValue("costPerBale"))
    local daysAllowedBales = g_farmCleanup.settings:getValue("daysAllowedBales")

    local itemsToSave = g_currentMission.itemSystem.itemsToSave
    local balesToRemove = {}

    -- fcDebug("itemsToSave")
    -- fcDebug(itemsToSave)

    for _, item in pairs(itemsToSave) do
        local object = item.item

        if object.isa ~= nil and object:isa(Bale) then
            balesToRemove[#balesToRemove + 1] = object
        end
    end

    for i = #balesToRemove, 1, -1 do
        -- fcDebug(balesToRemove[i])
        if balesToRemove[i].nodeId ~= nil then
            local x, _, z = getWorldTranslation(balesToRemove[i].nodeId)
            local farmlandId = g_farmlandManager:getFarmlandIdAtWorldPosition(x,z)
            local baleData = {
              id = numRemoved,
              type = "bale",
              farmId = balesToRemove[i].ownerFarmId,
              farmlandId = farmlandId,
              x = x,
              z = z,
              xmlFilename = balesToRemove[i].xmlFilename,
              isMissionBale = balesToRemove[i].isMissionBale
            }
            local checkItem = FarmCleanup:checkItem(baleData, daysAllowedBales)
            if checkItem then
              fcDebug("Removing bale: " .. balesToRemove[i].xmlFilename)
              -- save the bale to table
              table.insert(removedBales, {
                id = baleData.id,
                farmId = baleData.farmId,
                farmlandId = baleData.farmlandId,
                x = baleData.x,
                z = baleData.z
              })

              -- Charge the farm for the removal if set
              if baleCharge ~= nil and baleCharge ~= 0 then
                  local farm = g_farmManager:getFarmById(baleData.farmId)
                  if farm ~= nil then
                      -- Charge farm for bale removal
                      local moneyType = MoneyType.PURCHASE_BALES
                      g_currentMission:addMoneyChange(baleCharge, baleData.farmId, moneyType, true)
                      if farm ~= nil then
                          fcDebug("Bale Removal Charge for farm: " .. baleData.farmId)
                          farm:changeBalance(baleCharge, moneyType)
                      end
                  end
              end

              balesToRemove[i]:delete()
              numRemoved = numRemoved + 1
            end
        end
    end

    -- Check if bales removed and send them to website
    if removedBales ~= nil and #removedBales > 0 then

      print(string.format(" Info: Farm Cleanup removed %d bales from the map.",numRemoved))

      --Save path and filename
      local timestamp = getDate("%Y-%m-%d-%H-%M")
      local commandOutboxDir = getUserProfileAppPath()  .. "modSettings/FS25_FarmsCleanup/Logs"
      local savedFile = commandOutboxDir .. "/removedBales-" .. timestamp .. ".xml"

      --File Key for xml output
      local key ="removedBales"

      --save data to xml file
      newxmlFile = XMLFile.create(key, savedFile, key)

      local index = 0

      for _, p in pairs(removedBales) do
        --fcDebug(p)
        local subKey = string.format(".bale(%d)", index)

        newxmlFile:setString(key .. subKey .. "#id", tostring(p.id))
        newxmlFile:setString(key .. subKey .. "#farmId", tostring(p.farmId))
        newxmlFile:setString(key .. subKey .. "#farmlandId", tostring(p.farmlandId))
        newxmlFile:setString(key .. subKey .. "#x", tostring(p.x))
        newxmlFile:setString(key .. subKey .. "#z", tostring(p.z))

        index = index + 1
        p = {}
      end

      newxmlFile:save()
      newxmlFile:delete()
    end

    fcDebug("Bales Removed: " .. numRemoved)

end

function FarmCleanup:cleanBalesManual()
    fcDebug("FarmCleanup - cleanBalesManual")

    local numRemoved = 0
    local removedBales = {}
    local baleCharge = -self:getChargeAmount(g_farmCleanup.settings:getValue("costPerBale"))

    local itemsToSave = g_currentMission.itemSystem.itemsToSave
    local balesToRemove = {}

    for _, item in pairs(itemsToSave) do
        local object = item.item

        if object.isa ~= nil and object:isa(Bale) then
            balesToRemove[#balesToRemove + 1] = object
        end
    end

    for i = #balesToRemove, 1, -1 do
        -- fcDebug(balesToRemove[i])
        if balesToRemove[i].nodeId ~= nil then
            local x, _, z = getWorldTranslation(balesToRemove[i].nodeId)
            local farmlandId = g_farmlandManager:getFarmlandIdAtWorldPosition(x,z)
            local baleData = {
              id = numRemoved,
              type = "bale",
              farmId = balesToRemove[i].ownerFarmId,
              farmlandId = farmlandId,
              x = x,
              z = z,
              xmlFilename = balesToRemove[i].xmlFilename,
              isMissionBale = balesToRemove[i].isMissionBale
            }

            fcDebug("Removing bale: " .. balesToRemove[i].xmlFilename)
            -- save the bale to table
            table.insert(removedBales, {
              id = baleData.id,
              farmId = baleData.farmId,
              farmlandId = baleData.farmlandId,
              x = baleData.x,
              z = baleData.z
            })

            -- Charge the farm for the removal if set
            if baleCharge ~= nil and baleCharge ~= 0 then
                local farm = g_farmManager:getFarmById(baleData.farmId)
                if farm ~= nil then
                    -- Charge farm for bale removal
                    local moneyType = MoneyType.PURCHASE_BALES
                    g_currentMission:addMoneyChange(baleCharge, baleData.farmId, moneyType, true)
                    if farm ~= nil then
                        fcDebug("Bale Removal Charge for farm: " .. baleData.farmId)
                        farm:changeBalance(baleCharge, moneyType)
                    end
                end
            end

            balesToRemove[i]:delete()
            numRemoved = numRemoved + 1
        end
    end

    -- Check if bales removed and send them to website
    if removedBales ~= nil and #removedBales > 0 then

      print(string.format(" Info: Farm Cleanup removed %d bales from the map.",numRemoved))

      --Save path and filename
      local timestamp = getDate("%Y-%m-%d-%H-%M")
      local commandOutboxDir = getUserProfileAppPath()  .. "modSettings/FS25_FarmsCleanup/Logs"
      local savedFile = commandOutboxDir .. "/removedBales-" .. timestamp .. ".xml"

      --File Key for xml output
      local key ="removedBales"

      --save data to xml file
      newxmlFile = XMLFile.create(key, savedFile, key)

      local index = 0

      for _, p in pairs(removedBales) do
        --fcDebug(p)
        local subKey = string.format(".bale(%d)", index)

        newxmlFile:setString(key .. subKey .. "#id", tostring(p.id))
        newxmlFile:setString(key .. subKey .. "#farmId", tostring(p.farmId))
        newxmlFile:setString(key .. subKey .. "#farmlandId", tostring(p.farmlandId))
        newxmlFile:setString(key .. subKey .. "#x", tostring(p.x))
        newxmlFile:setString(key .. subKey .. "#z", tostring(p.z))

        index = index + 1
        p = {}
      end

      newxmlFile:save()
      newxmlFile:delete()
    end

    fcDebug("Bales Removed: " .. numRemoved)
    return numRemoved
end

function FarmCleanup:checkItem(data, daysAllowed)
    
    if daysAllowed ~= nil then
      daysAllowed = daysAllowed - 1
    end

    if daysAllowed == 0 then
      return true
    end

    fcDebug(string.format("Days Allowed Num: %d", daysAllowed))

    if daysAllowed == nil then
      daysAllowed = 3
    end

    local currentDay = g_currentMission.environment.currentDay
    fcDebug("currentDay: " .. currentDay)
    -- Check to see if item is already logged, if so then check if the logDay is > than 3 from current day.
    -- If 3+ days old, then delete the item / return true
    -- Otherwise return false
    local removeItem = false
    local matchFound = false

    local modSettingsFolderPath = getUserProfileAppPath()  .. "modSettings/FS25_FarmsCleanup"
    local modSettingsFile = modSettingsFolderPath .. "/LooseItems.xml"

    local key = "items"

    local itemData = {
      id = tonumber(data.id),
      type = tostring(data.type),
      farmId = tonumber(data.farmId),
      farmlandId = tonumber(data.farmlandId),
      x = data.x,
      z = data.z,
      xmlFilename = tostring(data.xmlFilename),
      logDay = tonumber(currentDay)
    }

    -- fcDebug(itemData)

    if ( fileExists(modSettingsFile) ) then

      local xmlFile = XMLFile.load(key, modSettingsFile)
      local existingItems = {}
      local updatedItems = {}
      local newxmlFile
    
      if xmlFile == nil then
        return false
      end
        
      -- Get items from xml file
      xmlFile:iterate(key .. ".item", function (_, itemKey)
        --print("itemKey: " .. itemKey)
        local existingItem = {
          id = xmlFile:getInt(itemKey .. "#id"),
          type = xmlFile:getString(itemKey .. "#type"),
          farmId = xmlFile:getInt(itemKey .. "#farmId"),
          farmlandId = xmlFile:getInt(itemKey .. "#farmlandId"),
          x = xmlFile:getFloat(itemKey .. "#x"),
          z = xmlFile:getFloat(itemKey .. "#z"),
          xmlFilename = xmlFile:getString(itemKey .. "#xmlFilename"),
          logDay = xmlFile:getInt(itemKey .. "#logDay"),
        }
        table.insert(existingItems, existingItem)
      end)

      -- Loop through existing items to see if there is a match to current
      for _, eis in ipairs(existingItems) do
        fcDebug("Checking for item match.")
        if eis.type == itemData.type 
          and eis.farmId == itemData.farmId 
          and eis.farmlandId == itemData.farmlandId 
          and MathUtil.round(eis.x,1) == MathUtil.round(itemData.x,1)
          and MathUtil.round(eis.z,1) == MathUtil.round(itemData.z,1)
          and eis.xmlFilename == itemData.xmlFilename 
        then
          -- Match found
          fcDebug("Item match found.")
          matchFound = true
          -- Get days diff
          local daysDiff = 0
          if eis.logDay ~= nil and eis.logDay > 0 and currentDay > 0 then
            daysDiff = tonumber(currentDay) - tonumber(eis.logDay)
          end
          fcDebug("Item days diff: " .. daysDiff)
          -- Check if mission bale and give them more time
          if data.isMissionBale then 
            daysAllowed = daysAllowed + 2
          end
          -- Check if days diff is more than allowed for type
          if daysDiff > daysAllowed then
            fcDebug("Found Item To Remove")
            removeItem = true
            table.removeElement(updatedItems, eis)
          else
            -- Age good, keep in file
            table.insert(updatedItems, eis)
          end
        else
            -- No Match, keep in file
            table.insert(updatedItems, eis)
        end
      end

      -- Check to see if no match, if not then add to file
      if matchFound == false then 
          -- No Match, add to file
          table.insert(updatedItems, itemData)
      end

      --save data to xml file
      newxmlFile = XMLFile.create(key, modSettingsFile, key)

      local index = 0

      for _, ui in pairs(updatedItems) do
        local subKey = string.format(".item(%d)", index)

        newxmlFile:setInt(key .. subKey .. "#id", tonumber(ui.id))
        newxmlFile:setString(key .. subKey .. "#type", tostring(ui.type))
        newxmlFile:setInt(key .. subKey .. "#farmId", tonumber(ui.farmId))
        newxmlFile:setInt(key .. subKey .. "#farmlandId", tonumber(ui.farmlandId))
        newxmlFile:setFloat(key .. subKey .. "#x", tonumber(ui.x))
        newxmlFile:setFloat(key .. subKey .. "#z", tonumber(ui.z))
        newxmlFile:setString(key .. subKey .. "#xmlFilename", tostring(ui.xmlFilename))
        newxmlFile:setInt(key .. subKey .. "#logDay", tonumber(ui.logDay))

        index = index + 1
      end

      newxmlFile:save()
      newxmlFile:delete()

    else 

      fcDebug("No LooseItems.xml yet.  Creating one.")

      local xmlFile = createXMLFile(key, modSettingsFile, key)

      setXMLInt(xmlFile, key .. ".item#id",tonumber(itemData.id))
      setXMLString(xmlFile, key .. ".item#type",tostring(itemData.type))
      setXMLInt(xmlFile, key .. ".item#farmId",tonumber(itemData.farmId))
      setXMLInt(xmlFile, key .. ".item#farmlandId",tonumber(itemData.farmlandId))
      setXMLFloat(xmlFile, key .. ".item#x",tonumber(itemData.x))
      setXMLFloat(xmlFile, key .. ".item#z",tonumber(itemData.z))
      setXMLString(xmlFile, key .. ".item#xmlFilename",tostring(itemData.xmlFilename))
      setXMLInt(xmlFile, key .. ".item#logDay",tonumber(itemData.logDay))

      saveXMLFile(xmlFile)
      delete(xmlFile)

    end

    return removeItem
end

-- Check to see if item is within radius
function FarmCleanup:isPointWithinRadius(startX, startZ, pointX, pointZ, radius)
    -- Create a radius around the pallet spawn start point
    local x1 = startX + radius
    local x2 = startX - radius
    local z1 = startZ + radius
    local z2 = startZ - radius
    
    -- Check if point is within the x and z ranges
    local inRangeX = FarmCleanup:isWithinRange(pointX, x2, x1)
    local inRangeZ = FarmCleanup:isWithinRange(pointZ, z2, z1)

    return inRangeX and inRangeZ
end

-- Helper function to check if a point is within a range
function FarmCleanup:isWithinRange(value, min, max)
    return value >= min and value <= max
end

-- Get the value for selected charge amount
function FarmCleanup:getChargeAmount(index)
  if index ~= nil then
      local values = { 0, 100, 250, 500, 750, 1000, 2500, 5000, 7500, 10000 }
      return values[index]
  end
  return 0
end