--
-- Settings Page
--

SettingsGuiSettingsFrame = {}

local SettingsGuiSettingsFrame_mt = Class(SettingsGuiSettingsFrame, TabbedMenuFrameElement)

function SettingsGuiSettingsFrame:new(subclass_mt, l10n)
    local self = SettingsGuiSettingsFrame:superClass().new(nil, subclass_mt or SettingsGuiSettingsFrame_mt)

    fcDebug("SettingsGuiSettingsFrame-new")

    self.messageCenter      = g_messageCenter
    self.l10n               = l10n
    self.isMPGame           = g_currentMission.missionDynamicInfo.isMultiplayer

    return self
end

function SettingsGuiSettingsFrame:copyAttributes(src)
    SettingsGuiSettingsFrame:superClass().copyAttributes(self, src)

    self.ui   = src.ui
    self.l10n = src.l10n
end

function SettingsGuiSettingsFrame:initialize()
    self.backButtonInfo = {inputAction = InputAction.MENU_BACK}
end

function SettingsGuiSettingsFrame:onGuiSetupFinished()
    SettingsGuiSettingsFrame:superClass().onGuiSetupFinished(self)

end

function SettingsGuiSettingsFrame:delete()
    SettingsGuiSettingsFrame:superClass().delete(self)
    self.messageCenter:unsubscribeAll(self)
end

function SettingsGuiSettingsFrame:updateMenuButtons()
    self.menuButtonInfo = {}
    self.menuButtonInfo = {
        {
            inputAction = InputAction.MENU_BACK
        }
    }

    self:setMenuButtonInfoDirty()
end

function SettingsGuiSettingsFrame:onFrameOpen()
    SettingsGuiSettingsFrame:superClass().onFrameOpen(self)

    fcDebug("SettingsGuiSettingsFrame:onFrameOpen")

    -- Load Settings
    g_farmCleanup.settings:loadSettings()

    self.isOpening = true

    -- Reload the settings
    self:updateSettings()

		self.fcSettingsLayout:setVisible(true)
		self.fcSettingsLayout:invalidateLayout()

    -- Alternates the background colors
    local set = true
    for _, tableRow in pairs(self.fcSettingsLayout.elements) do
      if tableRow.name == "sectionHeader" or tableRow.name == "settingsNoPermissionText" then
        set = true
      elseif tableRow:getIsVisible() then
        local color = InGameMenuSettingsFrame.COLOR_ALTERNATING[set]
        tableRow:setImageColor(nil, unpack(color))
        set = not set
      end
    end

    self.settingsNoPermissionText:setVisible(not g_currentMission:getIsServer() and not g_currentMission.isMasterUser)

end

function SettingsGuiSettingsFrame:onRefreshEvent()
  -- do nothing for now
end


function SettingsGuiSettingsFrame:onFrameClose()
    SettingsGuiSettingsFrame:superClass().onFrameClose(self)

    self.messageCenter:unsubscribeAll(self)
end

-- Update all of the settings
function SettingsGuiSettingsFrame:updateSettings()
  fcDebug("SettingsGuiSettingsFrame:updateSettings")

  local autoCleanPallets = g_farmCleanup.settings:getValue("autoCleanPallets")
  self.updateAutoCleanPallets:setIsChecked(autoCleanPallets, self.isOpening)
  self.updateAutoCleanPallets:setDisabled(not g_currentMission:getIsServer() and not g_currentMission.isMasterUser)

  local costPerPallet = g_farmCleanup.settings:getValue("costPerPallet")
  self.updatePalletCost:setState(costPerPallet)
  self.updatePalletCost:setDisabled(not g_currentMission:getIsServer() and not g_currentMission.isMasterUser)

  local daysAllowedPallets = g_farmCleanup.settings:getValue("daysAllowedPallets")
  self.updatePalletDaysAllowed:setState(daysAllowedPallets)
  self.updatePalletDaysAllowed:setDisabled(not g_currentMission:getIsServer() and not g_currentMission.isMasterUser)

  self.buttonCleanPallets:setText(g_i18n:getText("input_cleanPallets"))
  self.buttonCleanPallets:setDisabled(not g_currentMission:getIsServer() and not g_currentMission.isMasterUser)

  local autoCleanBales = g_farmCleanup.settings:getValue("autoCleanBales")
  self.updateAutoCleanBales:setIsChecked(autoCleanBales, self.isOpening)
  self.updateAutoCleanBales:setDisabled(not g_currentMission:getIsServer() and not g_currentMission.isMasterUser)

  local costPerBale = g_farmCleanup.settings:getValue("costPerBale")
  self.updateBaleCost:setState(costPerBale)
  self.updateBaleCost:setDisabled(not g_currentMission:getIsServer() and not g_currentMission.isMasterUser)

  local daysAllowedBales = g_farmCleanup.settings:getValue("daysAllowedBales")
  self.updateBaleDaysAllowed:setState(daysAllowedBales)
  self.updateBaleDaysAllowed:setDisabled(not g_currentMission:getIsServer() and not g_currentMission.isMasterUser)

  self.buttonCleanBales:setText(g_i18n:getText("input_cleanBales"))
  self.buttonCleanBales:setDisabled(not g_currentMission:getIsServer() and not g_currentMission.isMasterUser)

  local autoCleanLogs = g_farmCleanup.settings:getValue("autoCleanLogs")
  self.updateAutoCleanLogs:setIsChecked(autoCleanLogs, self.isOpening)
  self.updateAutoCleanLogs:setDisabled(not g_currentMission:getIsServer() and not g_currentMission.isMasterUser)

  local costPerLog = g_farmCleanup.settings:getValue("costPerLog")
  self.updateLogCost:setState(costPerLog)
  self.updateLogCost:setDisabled(not g_currentMission:getIsServer() and not g_currentMission.isMasterUser)

  self.buttonCleanLogs:setText(g_i18n:getText("input_cleanLogs"))
  self.buttonCleanLogs:setDisabled(not g_currentMission:getIsServer() and not g_currentMission.isMasterUser)

  local autoCleanStumps = g_farmCleanup.settings:getValue("autoCleanStumps")
  self.updateAutoCleanStumps:setIsChecked(autoCleanStumps, self.isOpening)
  self.updateAutoCleanStumps:setDisabled(not g_currentMission:getIsServer() and not g_currentMission.isMasterUser)

  local costPerStump = g_farmCleanup.settings:getValue("costPerStump")
  self.updateStumpCost:setState(costPerStump)
  self.updateStumpCost:setDisabled(not g_currentMission:getIsServer() and not g_currentMission.isMasterUser)

  self.buttonCleanStumps:setText(g_i18n:getText("input_cleanStumps"))
  self.buttonCleanStumps:setDisabled(not g_currentMission:getIsServer() and not g_currentMission.isMasterUser)

end

-- Update Functions to update settings changes

function SettingsGuiSettingsFrame:onClickUpdateAutoCleanPallets(state)
  fcDebug("SettingsGuiSettingsFrame:onClickUpdateAutoCleanPallets")
  g_farmCleanup.settings:setValue(
    "autoCleanPallets",
    state == CheckedOptionElement.STATE_CHECKED
  )
  g_farmCleanup.settings:saveSettings()
  if not self.isServer then
    -- Send setting data to the server
    if state == 1 then state = false else state = true end
    fcDebug('SettingsGuiSettingsFrame:onClickUpdateAutoCleanPallets: ')
    fcDebug(state)

    SettingEvent.sendEvent(2, "autoCleanPallets", state)
  end
end

function SettingsGuiSettingsFrame:onClickUpdatePalletCost(state)
  fcDebug("SettingsGuiSettingsFrame:onClickUpdatePalletCost")
  g_farmCleanup.settings:setValue("costPerPallet",state)
  g_farmCleanup.settings:saveSettings()
  if not self.isServer then
    -- Send setting data to the server
    fcDebug('SettingsGuiSettingsFrame:onClickUpdatePalletCost: ')
    fcDebug(state)

    SettingEvent.sendEvent(3, "costPerPallet", state)
  end
end

function SettingsGuiSettingsFrame:onClickUpdatePalletDaysAllowed(state)
  fcDebug("SettingsGuiSettingsFrame:onClickUpdatePalletDaysAllowed")
  g_farmCleanup.settings:setValue("daysAllowedPallets",state)
  g_farmCleanup.settings:saveSettings()
  if not self.isServer then
    -- Send setting data to the server
    fcDebug('SettingsGuiSettingsFrame:onClickUpdatePalletDaysAllowed: ')
    fcDebug(state)

    SettingEvent.sendEvent(3, "daysAllowedPallets", state)
  end
end

function SettingsGuiSettingsFrame:onClickCleanPallets()
  fcDebug("SettingsGuiSettingsFrame:onClickCleanPallets")
  ShowMessageDialogEvent.sendEvent(g_localPlayer.userId,g_i18n:getText("info_cleaningPallets"))
  ManualCleanEvent.sendEvent("pallets", g_localPlayer.userId)
end

function SettingsGuiSettingsFrame:onClickUpdateAutoCleanBales(state)
  fcDebug("SettingsGuiSettingsFrame:onClickUpdateAutoCleanBales")
  g_farmCleanup.settings:setValue(
    "autoCleanBales",
    state == CheckedOptionElement.STATE_CHECKED
  )
  g_farmCleanup.settings:saveSettings()
  if not self.isServer then
    -- Send setting data to the server
    if state == 1 then state = false else state = true end
    fcDebug('SettingsGuiSettingsFrame:onClickUpdateAutoCleanBales: ')
    fcDebug(state)

    SettingEvent.sendEvent(2, "autoCleanBales", state)
  end
end

function SettingsGuiSettingsFrame:onClickUpdateBaleCost(state)
  fcDebug("SettingsGuiSettingsFrame:onClickUpdateBaleCost")
  g_farmCleanup.settings:setValue("costPerBale",state)
  g_farmCleanup.settings:saveSettings()
  if not self.isServer then
    -- Send setting data to the server
    fcDebug('SettingsGuiSettingsFrame:onClickUpdateBaleCost: ')
    fcDebug(state)

    SettingEvent.sendEvent(3, "costPerBale", state)
  end
end

function SettingsGuiSettingsFrame:onClickUpdateBaleDaysAllowed(state)
  fcDebug("SettingsGuiSettingsFrame:onClickUpdateBaleDaysAllowed")
  g_farmCleanup.settings:setValue("daysAllowedBales",state)
  g_farmCleanup.settings:saveSettings()
  if not self.isServer then
    -- Send setting data to the server
    fcDebug('SettingsGuiSettingsFrame:onClickUpdateBaleDaysAllowed: ')
    fcDebug(state)

    SettingEvent.sendEvent(3, "daysAllowedBales", state)
  end
end

function SettingsGuiSettingsFrame:onClickCleanBales()
  fcDebug("SettingsGuiSettingsFrame:onClickCleanBales")
  ShowMessageDialogEvent.sendEvent(g_localPlayer.userId,g_i18n:getText("info_cleaningBales"))
  ManualCleanEvent.sendEvent("bales", g_localPlayer.userId)
end

function SettingsGuiSettingsFrame:onClickUpdateAutoCleanLogs(state)
  fcDebug("SettingsGuiSettingsFrame:onClickUpdateAutoCleanLogs")
  g_farmCleanup.settings:setValue(
    "autoCleanLogs",
    state == CheckedOptionElement.STATE_CHECKED
  )
  g_farmCleanup.settings:saveSettings()
  if not self.isServer then
    -- Send setting data to the server
    if state == 1 then state = false else state = true end
    fcDebug('SettingsGuiSettingsFrame:onClickUpdateAutoCleanLogs: ')
    fcDebug(state)

    SettingEvent.sendEvent(2, "autoCleanLogs", state)
  end
end

function SettingsGuiSettingsFrame:onClickUpdateLogCost(state)
  fcDebug("SettingsGuiSettingsFrame:onClickUpdateLogCost")
  g_farmCleanup.settings:setValue("costPerLog",state)
  g_farmCleanup.settings:saveSettings()
  if not self.isServer then
    -- Send setting data to the server
    fcDebug('SettingsGuiSettingsFrame:onClickUpdateLogCost: ')
    fcDebug(state)

    SettingEvent.sendEvent(3, "costPerLog", state)
  end
end

function SettingsGuiSettingsFrame:onClickCleanLogs()
  fcDebug("SettingsGuiSettingsFrame:onClickCleanLogs")
  ShowMessageDialogEvent.sendEvent(g_localPlayer.userId,g_i18n:getText("info_cleaningLogs"))
  ManualCleanEvent.sendEvent("logs", g_localPlayer.userId)
end

function SettingsGuiSettingsFrame:onClickUpdateAutoCleanStumps(state)
  fcDebug("SettingsGuiSettingsFrame:onClickUpdateAutoCleanStumps")
  g_farmCleanup.settings:setValue(
    "autoCleanStumps",
    state == CheckedOptionElement.STATE_CHECKED
  )
  g_farmCleanup.settings:saveSettings()
  if not self.isServer then
    -- Send setting data to the server
    if state == 1 then state = false else state = true end
    fcDebug('SettingsGuiSettingsFrame:onClickUpdateAutoCleanStumps: ')
    fcDebug(state)

    SettingEvent.sendEvent(2, "autoCleanStumps", state)
  end
end

function SettingsGuiSettingsFrame:onClickUpdateStumpCost(state)
  fcDebug("SettingsGuiSettingsFrame:onClickUpdateStumpCost")
  g_farmCleanup.settings:setValue("costPerStump",state)
  g_farmCleanup.settings:saveSettings()
  if not self.isServer then
    -- Send setting data to the server
    fcDebug('SettingsGuiSettingsFrame:onClickUpdateStumpCost: ')
    fcDebug(state)

    SettingEvent.sendEvent(3, "costPerStump", state)
  end
end

function SettingsGuiSettingsFrame:onClickCleanStumps()
  fcDebug("SettingsGuiSettingsFrame:onClickCleanStumps")
  ShowMessageDialogEvent.sendEvent(g_localPlayer.userId,g_i18n:getText("info_cleaningStumps"))
  ManualCleanEvent.sendEvent("stumps", g_localPlayer.userId)
end